/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.progression;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.api.common.data.IKillData;
import dev.toma.gunsrpg.resource.progression.ILevelReward;
import dev.toma.gunsrpg.resource.progression.ILevelRewardAdapter;
import dev.toma.gunsrpg.resource.progression.IProgressionStrategy;
import dev.toma.gunsrpg.resource.progression.LevelRewards;
import dev.toma.gunsrpg.resource.util.functions.Functions;
import dev.toma.gunsrpg.resource.util.functions.IFunction;
import dev.toma.gunsrpg.resource.util.functions.IFunctionAdapter;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.lang.reflect.Type;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ProgressionStrategy
implements IProgressionStrategy {
    private final KillRequirement[] requirements;
    private final Reward[] rewards;

    public ProgressionStrategy(KillRequirement[] requirements, Reward[] rewards) {
        this.requirements = requirements;
        this.rewards = rewards;
    }

    @Override
    public int getRequiredKillCount(int level) {
        for (KillRequirement requirement : this.requirements) {
            if (!requirement.function.canApplyFor(level)) continue;
            return requirement.amount;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void applyRewards(PlayerEntity player, IKillData data, int level) {
        for (Reward reward : this.rewards) {
            if (!reward.function.canApplyFor(level)) continue;
            for (ILevelReward levelReward : reward.rewards) {
                levelReward.applyTo(player, data);
            }
            break;
        }
    }

    private static class KillRequirement {
        private final IFunction function;
        private final int amount;

        public KillRequirement(IFunction function, int amount) {
            this.function = function;
            this.amount = amount;
        }

        static KillRequirement fromJson(JsonElement element) {
            JsonObject object = JsonHelper.asJsonObject(element);
            String functionId = JSONUtils.func_151200_h((JsonObject)object, (String)"function");
            IFunctionAdapter adapter = Functions.getRegistry().getAdapter(functionId);
            if (adapter == null) {
                throw new JsonSyntaxException("Unknown function " + functionId);
            }
            Object function = adapter.resolveFromJson(object);
            int required = JSONUtils.func_151203_m((JsonObject)object, (String)"require");
            return new KillRequirement((IFunction)function, required);
        }
    }

    private static class Reward {
        private final IFunction function;
        private final ILevelReward[] rewards;

        private Reward(IFunction function, ILevelReward[] rewards) {
            this.function = function;
            this.rewards = rewards;
        }

        static Reward fromJson(JsonElement element) {
            JsonObject object = JsonHelper.asJsonObject(element);
            String functionId = JSONUtils.func_151200_h((JsonObject)object, (String)"function");
            IFunctionAdapter adapter = Functions.getRegistry().getAdapter(functionId);
            if (adapter == null) {
                throw new JsonSyntaxException("Unknown function " + functionId);
            }
            Object function = adapter.resolveFromJson(object);
            JsonArray rewardJson = JSONUtils.func_151214_t((JsonObject)object, (String)"rewards");
            ILevelReward[] rewards = JsonHelper.deserializeInto(rewardJson, ILevelReward[]::new, Reward::resolveReward);
            return new Reward((IFunction)function, rewards);
        }

        static ILevelReward resolveReward(JsonElement element) {
            JsonObject object = JsonHelper.asJsonObject(element);
            String adapterId = JSONUtils.func_151200_h((JsonObject)object, (String)"type");
            ILevelRewardAdapter adapter = LevelRewards.getAdapter(new ResourceLocation(adapterId));
            if (adapter == null) {
                throw new JsonSyntaxException("Unknown reward type " + adapterId);
            }
            return adapter.resolveFromJson(object);
        }
    }

    public static class Adapter
    implements JsonDeserializer<IProgressionStrategy> {
        public IProgressionStrategy deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(json);
            JsonArray requirementArray = JSONUtils.func_151214_t((JsonObject)object, (String)"killRequirements");
            KillRequirement[] requirements = JsonHelper.deserializeInto(requirementArray, KillRequirement[]::new, KillRequirement::fromJson);
            JsonArray rewardArray = JSONUtils.func_151214_t((JsonObject)object, (String)"rewards");
            Reward[] rewards = JsonHelper.deserializeInto(rewardArray, Reward[]::new, Reward::fromJson);
            return new ProgressionStrategy(requirements, rewards);
        }
    }
}

